/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.debuffs.DebuffDataManager;
import dev.toma.gunsrpg.common.init.ModDebuffSources;
import dev.toma.gunsrpg.common.init.ModDebuffStageEvents;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.init.ModTags;
import dev.toma.gunsrpg.common.item.SlingItem;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.resource.crate.LootManager;
import dev.toma.gunsrpg.resource.gunner.ZombieGunnerWeaponManager;
import dev.toma.gunsrpg.resource.perks.PerkManager;
import dev.toma.gunsrpg.resource.progression.ProgressionStrategyManager;
import dev.toma.gunsrpg.resource.skill.SkillPropertyLoader;
import dev.toma.gunsrpg.resource.startgear.StartGearManager;
import dev.toma.gunsrpg.util.ParrotMobSoundMapCustomizer;
import dev.toma.gunsrpg.util.locate.ILocatorPredicate;
import dev.toma.gunsrpg.world.mayor.VillageFeatureMutator;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Lifecycle {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Lifecycle");
    private final Map<GunItem, IAmmoProvider[]> weaponProviderMap = new IdentityHashMap<GunItem, IAmmoProvider[]>();
    private final Map<Item, Item> ore2ChunkMap = new IdentityHashMap<Item, Item>(2);
    private final StartGearManager startingGearManager = new StartGearManager();
    private final ZombieGunnerWeaponManager zombieGunnerWeaponManager = new ZombieGunnerWeaponManager();
    private final LootManager lootManager = new LootManager();
    private final ProgressionStrategyManager progressionStrategyManager = new ProgressionStrategyManager();
    private final PerkManager perkManager = new PerkManager();
    private final QuestSystem questSystem = new QuestSystem();
    private final DebuffDataManager debuffDataManager = new DebuffDataManager();

    public void modInit() {
        ModTags.init();
        MinecraftForge.EVENT_BUS.addListener(this::onDatapackReload);
    }

    public void commonInit() {
        this.initWeaponProviderMap();
        this.initOreToChunkMap();
        ModRecipeTypes.register();
        SlingItem.initAmmoRegistry();
        VillageFeatureMutator.mutateVanillaVillages();
        ModDebuffStageEvents.register();
        ModDebuffSources.register();
        ParrotMobSoundMapCustomizer.customizeParrotMobSoundMap();
    }

    public StartGearManager getStartingGearManager() {
        return this.startingGearManager;
    }

    public ZombieGunnerWeaponManager getZombieGunnerWeaponManager() {
        return this.zombieGunnerWeaponManager;
    }

    public LootManager getAirdropLootManager() {
        return this.lootManager;
    }

    public ProgressionStrategyManager getProgressionStrategyManager() {
        return this.progressionStrategyManager;
    }

    public PerkManager getPerkManager() {
        return this.perkManager;
    }

    public DebuffDataManager getDebuffDataManager() {
        return this.debuffDataManager;
    }

    public QuestSystem quests() {
        return this.questSystem;
    }

    @Nullable
    public Item getOreDropReplacement(Item src) {
        return this.ore2ChunkMap.get(src);
    }

    @Nullable
    public IAmmoProvider getAmmoForWeapon(GunItem item, ItemStack stack) {
        IAmmoMaterial material = item.getMaterialFromNBT(stack);
        if (material == null) {
            return null;
        }
        AmmoType ammoType = item.getAmmoType();
        ILocatorPredicate<IAmmoProvider> predicate = provider -> ammoType == provider.getAmmoType() && material == provider.getMaterial();
        for (IAmmoProvider provider2 : this.getAllCompatibleAmmoProviders(item)) {
            if (!predicate.isValidResult(provider2)) continue;
            return provider2;
        }
        return null;
    }

    public IAmmoProvider[] getAllCompatibleAmmoProviders(GunItem gunItem) {
        return this.weaponProviderMap.get(gunItem);
    }

    private void initWeaponProviderMap() {
        GunsRPG.log.debug(MARKER, "Making weapon -> ammo mappings");
        long startTime = System.currentTimeMillis();
        Collection items = ForgeRegistries.ITEMS.getValues();
        List weapons = items.stream().filter(it -> it instanceof GunItem).map(it -> (GunItem)it).collect(Collectors.toList());
        List ammoProviders = items.stream().filter(it -> it instanceof IAmmoProvider).map(it -> (IAmmoProvider)it).collect(Collectors.toList());
        for (GunItem weapon : weapons) {
            AmmoType type = weapon.getAmmoType();
            Set<IAmmoMaterial> materials = weapon.getCompatibleMaterials();
            IAmmoProvider[] providers = (IAmmoProvider[])ammoProviders.stream().filter(provider -> provider.getAmmoType() == type && materials.contains(provider.getMaterial())).toArray(IAmmoProvider[]::new);
            this.weaponProviderMap.put(weapon, providers);
        }
        long len = System.currentTimeMillis() - startTime;
        GunsRPG.log.debug(MARKER, "Weapon -> ammo mappings finished, took {}ms", (Object)len);
    }

    private void initOreToChunkMap() {
        this.ore2ChunkMap.put(Blocks.field_150366_p.func_199767_j(), ModItems.IRON_ORE_CHUNK);
        this.ore2ChunkMap.put(Blocks.field_150352_o.func_199767_j(), ModItems.GOLD_ORE_CHUNK);
    }

    private void onDatapackReload(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this.startingGearManager);
        event.addListener((IFutureReloadListener)this.zombieGunnerWeaponManager);
        event.addListener((IFutureReloadListener)new SkillPropertyLoader());
        event.addListener((IFutureReloadListener)this.lootManager);
        event.addListener((IFutureReloadListener)this.progressionStrategyManager);
        event.addListener((IFutureReloadListener)this.perkManager);
        event.addListener((IFutureReloadListener)this.perkManager.configLoader);
        event.addListener((IFutureReloadListener)this.debuffDataManager);
        this.questSystem.initialize(event);
    }
}

